package jamezo97.clonecraft.render;

import jamezo97.clonecraft.dna.Gene;
import net.minecraft.client.renderer.entity.CloneCraftRenderHook;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

public class RenderCustom extends Render{

	ResourceLocation missingImage = new ResourceLocation("missingno");

	public static float scale = 1.0f;

	@Override
	public void doRender(Entity entity, double d0, double d1, double d2, float f, float f1) {
		CCEntityAnything custom = (CCEntityAnything)entity;
		if(custom.theEntity != null){
			Render render = getRender(custom);
			
			GL11.glPushMatrix();
			if(custom.hasGene(Gene.large) || custom.hasGene(Gene.small)){
				GL11.glTranslated(d0, d1, d2);
				float scalef = 1;
				if(custom.hasGene(Gene.large)){
//					System.out.println("Render with large");
					scalef = custom.getGeneStrength(Gene.large);
				}
				if(custom.hasGene(Gene.small)){
					
					scalef = scalef / ((float)custom.getGeneStrength(Gene.small));
				}
				GL11.glScalef(scalef , scalef, scalef);
				GL11.glTranslated(-d0, -d1, -d2);
			}
			

			render.doRender(custom.theEntity, d0, d1, d2, f, f1);
			GL11.glPopMatrix();
		}

	}

	@Override
	protected ResourceLocation getEntityTexture(Entity entity) {
		Render render = getRender(entity);
		if(render != null){
			return CloneCraftRenderHook.getEntityTexture(render, entity);
		}else{
			return missingImage;
		}
	}

	public Render getRender(Entity entity){
		CCEntityAnything custom = (CCEntityAnything)entity;
		if(custom.theEntity == null){return null;}
		return RenderManager.instance.getEntityClassRenderObject(custom.theEntity.getClass());
	}



}
